import {
    ItemStack,
    system,
    world
} from "@minecraft/server"

world.beforeEvents.worldInitialize.subscribe(event => {
    event.blockComponentRegistry.registerCustomComponent("component:test", {
        beforeOnPlayerPlace: (event) => {
            world.sendMessage("block: beforeOnPlayerPlace triggered")
        },
        onPlace: (event) => {
            world.sendMessage("block: onPlace triggered")
        },
    })
    event.itemComponentRegistry.registerCustomComponent("component:test_item", {
        onUseOn: (event) => {
            world.sendMessage("item: onUseOn triggered")
        }
    })
})

world.afterEvents.playerJoin.subscribe(event => {
    const playerId = event.playerId
    const player = world.getEntity(playerId)
    player.getComponent("inventory").container.addItem(new ItemStack("test:test", 1))
})